/*
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : main.c
    Description  :
    Date         : 29 October 2010
    Version      : v1.00
    Changelog    : v1.00 Initial
*/
#include <include.h>
#include <stdio.h>

void Delay(void)
{
   volatile int iDelay = 0x1FFFF;

   while (iDelay--);
}


int main (void)
{

   // Initialise
   T3CON &= ~T3CON_ENABLE;  // Turn off watchdog
   
   GP1CON = GP1CON_CON0_UART0RXD | GP1CON_CON1_UART0TXD; // UART
   Urt_Init(UART_BAUD_19200);
   Urt_PinSetup(FALSE);   
   printf("ADuCRF101 test routine!\n");

   GP4CON = GP4CON_CON2_GPIO | GP4CON_CON3_GPIO | GP4CON_CON6_GPIO | GP4CON_CON7_GPIO;
   GP4OEN = GP4OEN_OEN2;  
   
   while(1)
      {
      GP4TGL = GPTGL_TGL2; // toggle P4.2
      Delay();
      }
}






